/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.util.FileUtils;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class IndentedWriter {
    public static final IndentedWriter stdout = new IndentedWriter(System.out);
    public static final IndentedWriter stderr = new IndentedWriter(System.err);
    protected PrintWriter out = null;
    protected static final int INDENT = 2;
    protected int unitIndent = 2;
    protected int currentIndent = 0;
    protected int column = 0;
    protected int row = 1;
    protected boolean lineNumbers = false;
    protected boolean startingNewLine = true;
    char lastChar = '\u0000';
    private static int WidthLineNumber = 3;

    public IndentedWriter() {
        this(System.out, false);
    }

    protected IndentedWriter(IndentedWriter other) {
        this.out = other.out;
        this.lineNumbers = other.lineNumbers;
        if (other.column != this.column || other.row != this.row) {
            throw new ARQInternalErrorException("Can only clone am unstarted IndentedWriter");
        }
    }

    public IndentedWriter(OutputStream outStream) {
        this(outStream, false);
    }

    public IndentedWriter(OutputStream outStream, boolean withLineNumbers) {
        this(FileUtils.asPrintWriterUTF8((OutputStream)outStream), withLineNumbers);
    }

    IndentedWriter(Writer writer) {
        this(new PrintWriter(writer), false);
    }

    IndentedWriter(Writer writer, boolean withLineNumbers) {
        this(new PrintWriter(writer), withLineNumbers);
    }

    IndentedWriter(PrintWriter printWriter) {
        this(printWriter, false);
    }

    IndentedWriter(PrintWriter printWriter, boolean withLineNumbers) {
        this.out = printWriter;
        this.lineNumbers = withLineNumbers;
        this.startingNewLine = true;
    }

    public void print(Object obj) {
        String s = "null";
        if (obj != null) {
            s = obj.toString();
        }
        for (int i = 0; i < s.length(); ++i) {
            this.printChWorker(s.charAt(i));
        }
    }

    public void print(char ch) {
        this.printChWorker(ch);
    }

    public void println(Object obj) {
        this.print(obj);
        this.newline();
    }

    public void println(char ch) {
        this.print(ch);
        this.newline();
    }

    public void println() {
        this.newline();
    }

    private void printChWorker(char ch) {
        if (ch == '\n' && this.lastChar == '\r') {
            this.lastChar = ch;
            return;
        }
        this.lineStart();
        this.lastChar = ch;
        if (ch == '\n' || ch == '\r') {
            this.newline();
            return;
        }
        this.out.print(ch);
        ++this.column;
    }

    public void print(String s, int n) {
        for (int i = 0; i < n; ++i) {
            this.print(s);
        }
    }

    public void print(char ch, int n) {
        this.lineStart();
        for (int i = 0; i < n; ++i) {
            this.printChWorker(ch);
        }
    }

    public void newline() {
        this.lineStart();
        this.out.println();
        this.startingNewLine = true;
        ++this.row;
        this.column = 0;
    }

    private boolean atStartOfLine() {
        return this.column <= this.currentIndent;
    }

    public void ensureStartOfLine() {
        if (!this.atStartOfLine()) {
            this.newline();
        }
    }

    public void close() {
        this.out.flush();
    }

    public void flush() {
        this.out.flush();
    }

    public void pad() {
        if (this.startingNewLine && this.currentIndent > 0) {
            this.lineStart();
        }
        this.padInt();
    }

    public void pad(int col) {
        this.pad(col, false);
    }

    public void pad(int col, boolean absoluteColumn) {
        if (!absoluteColumn) {
            col += this.currentIndent;
        }
        int spaces = col - this.column;
        for (int i = 0; i < spaces; ++i) {
            this.out.print(' ');
            ++this.column;
        }
    }

    private void padInt() {
        for (int i = this.column; i < this.currentIndent; ++i) {
            this.out.print(' ');
            ++this.column;
        }
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.column;
    }

    public int getIndent() {
        return this.currentIndent;
    }

    public int getCurrentOffset() {
        return this.getCol() - this.getIndent();
    }

    public boolean hasLineNumbers() {
        return this.lineNumbers;
    }

    public void setLineNumbers(boolean lineNumbers) {
        this.lineNumbers = lineNumbers;
    }

    public void incIndent(int x) {
        this.currentIndent += x;
    }

    public void incIndent() {
        this.incIndent(this.unitIndent);
    }

    public void decIndent(int x) {
        this.currentIndent -= x;
    }

    public void decIndent() {
        this.decIndent(this.unitIndent);
    }

    public void setUnitIndent(int x) {
        this.unitIndent = x;
    }

    public int getUnitIndent() {
        return this.unitIndent;
    }

    public void setAbsoluteIndent(int x) {
        this.currentIndent = x;
    }

    public boolean atLineStart() {
        return this.startingNewLine;
    }

    private void lineStart() {
        if (this.startingNewLine) {
            this.insertLineNumber();
        }
        this.padInt();
        this.startingNewLine = false;
    }

    private void insertLineNumber() {
        if (!this.lineNumbers) {
            return;
        }
        String s = Integer.toString(this.row);
        for (int i = 0; i < WidthLineNumber - s.length(); ++i) {
            this.out.print(' ');
        }
        this.out.print(s);
        this.out.print(' ');
    }
}

