/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer.probability.impl;

import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.Histogram;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.HistogramClass;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.Vocabulary;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.Pattern;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.ProbabilityIndex;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndexModelAccess {
    private int level = 1;
    private long size = -1L;
    private long resources = -1L;
    private long ssSize = -1L;
    private long soSize = -1L;
    private long osSize = -1L;
    private long ooSize = -1L;
    private Map properties = new HashMap();
    private Map histograms = new HashMap();
    private Map patterns = new HashMap();
    private Set exclude = new HashSet();
    private static Log log = LogFactory.getLog((Class)IndexModelAccess.class);

    public void load(Model model) {
        ResIterator resIter = null;
        Resource ontologyR = model.createResource(Vocabulary.PFI.getURI(), OWL.Ontology);
        if (ontologyR == null) {
            log.fatal((Object)"No a valid index model");
            return;
        }
        this.level = ontologyR.getProperty(Vocabulary.level).getInt();
        this.size = ontologyR.getProperty(Vocabulary.size).getLong();
        this.resources = ontologyR.getProperty(Vocabulary.resources).getLong();
        this.ssSize = ontologyR.getProperty(Vocabulary.ssSize).getLong();
        this.soSize = ontologyR.getProperty(Vocabulary.soSize).getLong();
        this.osSize = ontologyR.getProperty(Vocabulary.osSize).getLong();
        this.ooSize = ontologyR.getProperty(Vocabulary.ooSize).getLong();
        Bag excludeB = ontologyR.getProperty(Vocabulary.exclude).getBag();
        NodeIterator iter = excludeB.iterator();
        while (iter.hasNext()) {
            Resource resource = (Resource)iter.next();
            this.exclude.add(ResourceFactory.createProperty((String)resource.getURI()));
        }
        resIter = model.listSubjectsWithProperty(RDF.type, (RDFNode)RDF.Property);
        while (resIter.hasNext()) {
            Resource propertyR = resIter.nextResource();
            Property property = ResourceFactory.createProperty((String)propertyR.getProperty(Vocabulary.property).getResource().getURI());
            long frequency = propertyR.getProperty(Vocabulary.frequency).getLong();
            this.properties.put(property, new Long(frequency));
            log.debug((Object)("Added property to index: " + property.toString() + ", " + frequency));
            Resource histogramR = propertyR.getProperty(Vocabulary.histogram).getResource();
            Seq classesS = histogramR.getProperty(Vocabulary.classes).getSeq();
            Histogram histogram = new Histogram();
            histogram.setLowerBound(histogramR.getProperty(Vocabulary.lowerBound).getDouble());
            histogram.setUpperBound(histogramR.getProperty(Vocabulary.upperBound).getDouble());
            histogram.setClassSize(histogramR.getProperty(Vocabulary.classSize).getDouble());
            this.histograms.put(property, histogram);
            log.debug((Object)("Added histogram to index: [" + histogram.getLowerBound() + "," + histogram.getUpperBound() + "], " + histogram.getClassSize()));
            NodeIterator iter2 = classesS.iterator();
            while (iter2.hasNext()) {
                Resource histogramClassR = (Resource)iter2.next();
                HistogramClass histogramClass = new HistogramClass();
                histogramClass.setLowerBound(histogramClassR.getProperty(Vocabulary.lowerBound).getDouble());
                histogramClass.setFrequency(histogramClassR.getProperty(Vocabulary.frequency).getLong());
                histogram.addClass(histogramClass);
                log.debug((Object)("Added histogram class to index: " + histogramClass.getLowerBound() + ", " + histogramClass.getFrequency()));
            }
        }
        resIter.close();
        resIter = model.listSubjectsWithProperty(RDF.type, (RDFNode)Vocabulary.Pattern);
        while (resIter.hasNext()) {
            Resource patternR = resIter.nextResource();
            Property joiningProperty = ResourceFactory.createProperty((String)patternR.getProperty(Vocabulary.joiningProperty).getResource().getURI());
            Property joinedProperty = ResourceFactory.createProperty((String)patternR.getProperty(Vocabulary.joinedProperty).getResource().getURI());
            Resource joinType = ResourceFactory.createResource((String)patternR.getProperty(Vocabulary.joinType).getResource().getURI());
            long frequency = patternR.getProperty(Vocabulary.frequency).getLong();
            Pattern pattern = new Pattern(joiningProperty, joinedProperty, joinType);
            this.patterns.put(pattern, new Long(frequency));
            log.debug((Object)("Added pattern to index: " + frequency + " " + pattern.toString()));
        }
        resIter.close();
    }

    public Model create(ProbabilityIndex index) {
        long frequency;
        Property property;
        Map properties = index.getProperties();
        Map histograms = index.getHistograms();
        Map patterns = index.getPatterns();
        Set exclude = index.getExProperty();
        Model model = ModelFactory.createDefaultModel();
        Resource ontologyR = model.createResource(Vocabulary.PFI.getURI(), OWL.Ontology);
        ontologyR.addProperty(Vocabulary.ssSize, new Long(index.getIndexedSSSize()).toString());
        ontologyR.addProperty(Vocabulary.soSize, new Long(index.getIndexedSOSize()).toString());
        ontologyR.addProperty(Vocabulary.osSize, new Long(index.getIndexedOSSize()).toString());
        ontologyR.addProperty(Vocabulary.ooSize, new Long(index.getIndexedOOSize()).toString());
        ontologyR.addProperty(Vocabulary.size, new Long(index.getIndexedSize()).toString());
        ontologyR.addProperty(Vocabulary.resources, new Long(index.getIndexedNumRes()).toString());
        ontologyR.addProperty(Vocabulary.version, "0.2");
        ontologyR.addProperty(Vocabulary.level, new Integer(index.getLevel()).toString());
        Bag excludeB = model.createBag();
        ontologyR.addProperty(Vocabulary.exclude, (RDFNode)excludeB);
        Iterator<Object> iter = exclude.iterator();
        while (iter.hasNext()) {
            property = (Property)iter.next();
            excludeB.add((RDFNode)property);
        }
        iter = properties.keySet().iterator();
        while (iter.hasNext()) {
            property = (Property)iter.next();
            frequency = (Long)properties.get(property);
            Resource propertyR = model.createResource();
            propertyR.addProperty(RDF.type, (RDFNode)RDF.Property);
            propertyR.addProperty(Vocabulary.property, (RDFNode)property);
            propertyR.addProperty(Vocabulary.frequency, new Long(frequency).toString());
            Histogram histogram = (Histogram)histograms.get(property);
            Resource histogramR = model.createResource();
            histogramR.addProperty(RDF.type, (RDFNode)Vocabulary.Histogram);
            histogramR.addProperty(Vocabulary.lowerBound, new Double(histogram.getLowerBound()).toString());
            histogramR.addProperty(Vocabulary.upperBound, new Double(histogram.getUpperBound()).toString());
            histogramR.addProperty(Vocabulary.classSize, new Double(histogram.getClassSize()).toString());
            Seq histogramS = model.createSeq();
            Set histogramClasses = histogram.getClasses();
            Iterator it = histogramClasses.iterator();
            while (it.hasNext()) {
                HistogramClass histogramClass = (HistogramClass)it.next();
                double classLowerBound = histogramClass.getLowerBound();
                long classFrequency = histogramClass.getFrequency();
                Resource histogramClassR = model.createResource();
                histogramClassR.addProperty(RDF.type, (RDFNode)Vocabulary.HistogramClass);
                histogramClassR.addProperty(Vocabulary.lowerBound, new Double(classLowerBound).toString());
                histogramClassR.addProperty(Vocabulary.frequency, new Long(classFrequency).toString());
                histogramS.add((RDFNode)histogramClassR);
            }
            histogramR.addProperty(Vocabulary.classes, (RDFNode)histogramS);
            propertyR.addProperty(Vocabulary.histogram, (RDFNode)histogramR);
        }
        iter = patterns.keySet().iterator();
        while (iter.hasNext()) {
            Pattern pattern = (Pattern)iter.next();
            frequency = (Long)patterns.get(pattern);
            Resource patternR = model.createResource();
            patternR.addProperty(RDF.type, (RDFNode)Vocabulary.Pattern);
            patternR.addProperty(Vocabulary.joiningProperty, (RDFNode)pattern.getJoiningProperty());
            patternR.addProperty(Vocabulary.joinedProperty, (RDFNode)pattern.getJoinedProperty());
            patternR.addProperty(Vocabulary.joinType, (RDFNode)pattern.getJoinType());
            patternR.addProperty(Vocabulary.frequency, new Long(frequency).toString());
        }
        return model;
    }

    public int getLevel() {
        return this.level;
    }

    public long getSize() {
        return this.size;
    }

    public long getResources() {
        return this.resources;
    }

    public long getSSSize() {
        return this.ssSize;
    }

    public long getSOSize() {
        return this.soSize;
    }

    public long getOSSize() {
        return this.osSize;
    }

    public long getOOSize() {
        return this.ooSize;
    }

    public Map getProperties() {
        return this.properties;
    }

    public Map getHistograms() {
        return this.histograms;
    }

    public Map getPatterns() {
        return this.patterns;
    }

    public Set getExProperty() {
        return this.exclude;
    }
}

